import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class Calculator extends JFrame {
    private JTextField num1 = new JTextField(10);
    private JTextField num2 = new JTextField(10);
    private JTextField result = new JTextField(10);

    public Calculator() {
        setTitle("Super Simple Calculator");
        setSize(300, 200);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        setLayout(new GridLayout(5, 2));

        add(new JLabel("Number 1:"));
        add(num1);
        add(new JLabel("Number 2:"));
        add(num2);

        addButton("Add", "+");
        addButton("Subtract", "-");
        addButton("Multiply", "*");
        addButton("Divide", "/");

        add(new JLabel("Result:"));
        result.setEditable(false);
        add(result);

        setLocationRelativeTo(null);
        setVisible(true);
    }

    private void addButton(String label, String op) {
        JButton btn = new JButton(label);
        btn.addActionListener(e -> {
            try {
                double a = Double.parseDouble(num1.getText());
                double b = Double.parseDouble(num2.getText());
                double res = switch (op) {
                    case "+" -> a + b;
                    case "-" -> a - b;
                    case "*" -> a * b;
                    case "/" -> a / b;
                    default -> 0;
                };
                result.setText(String.format("%.2f", res));
            } catch (Exception ex) {
                result.setText("Error");
            }
        });
        add(btn);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(Calculator::new);
    }
}
